/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialIngredient
extends class_1856 {
    private static final MaterialId WILDCARD = IMaterial.UNKNOWN.getIdentifier();
    private final MaterialVariantId material;
    @Nullable
    private class_1856.class_1859[] values;
    @Nullable
    private class_1799[] materialStacks;

    protected MaterialIngredient(Stream<? extends class_1856.class_1859> itemLists, MaterialVariantId material) {
        super(itemLists);
        this.material = material;
    }

    public static MaterialIngredient fromItem(IMaterialItem item, MaterialId material) {
        return new MaterialIngredient(Stream.of(new class_1856.class_1857(new class_1799((class_1935)item))), material);
    }

    public static MaterialIngredient fromItem(IMaterialItem item) {
        return MaterialIngredient.fromItem(item, WILDCARD);
    }

    public static MaterialIngredient fromTag(class_6862<class_1792> tag, MaterialId material) {
        return new MaterialIngredient(Stream.of(new class_1856.class_1858(tag)), material);
    }

    public static MaterialIngredient fromTag(class_6862<class_1792> tag) {
        return MaterialIngredient.fromTag(tag, WILDCARD);
    }

    public boolean method_8093(@Nullable class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (!WILDCARD.equals(this.material) && !this.material.matchesVariant(stack)) {
            return false;
        }
        return super.method_8093(stack);
    }

    public class_1799[] method_8105() {
        if (this.materialStacks == null) {
            if (!MaterialRegistry.isFullyLoaded()) {
                return this.getPlainMatchingStacks();
            }
            Stream<Object> items = Arrays.stream(this.getPlainMatchingStacks());
            items = this.material.equals(WILDCARD) ? items.flatMap(stack -> MaterialRegistry.getMaterials().stream().map(mat -> IMaterialItem.withMaterial(stack, mat.getIdentifier())).filter(class_1799::method_7985)) : items.map(stack -> IMaterialItem.withMaterial(stack, this.material)).filter(class_1799::method_7985);
            this.materialStacks = (class_1799[])items.distinct().toArray(class_1799[]::new);
        }
        return this.materialStacks;
    }

    private class_1799[] getPlainMatchingStacks() {
        return super.method_8105();
    }

    public JsonElement method_8089() {
        JsonElement parent = super.method_8089();
        if (!parent.isJsonObject()) {
            throw new JsonIOException("Cannot serialize an array of material ingredients, use CompoundIngredient instead");
        }
        JsonObject object = parent.getAsJsonObject();
        object.addProperty("fabric:type", Serializer.ID.toString());
        if (this.material != WILDCARD) {
            object.addProperty("material", this.material.toString());
        }
        return object;
    }

    public FabricMaterialIngredient getCustomIngredient() {
        return new FabricMaterialIngredient(this);
    }

    public static class Serializer
    implements CustomIngredientSerializer<FabricMaterialIngredient> {
        public static final class_2960 ID = TConstruct.getResource("material");
        public static final Serializer INSTANCE = new Serializer();

        public class_2960 getIdentifier() {
            return ID;
        }

        public FabricMaterialIngredient read(JsonObject json) {
            MaterialId material = json.has("material") ? new MaterialId(class_3518.method_15265((JsonObject)json, (String)"material")) : WILDCARD;
            if (json.has("fabric:type")) {
                json.remove("fabric:type");
            }
            return new FabricMaterialIngredient(Stream.of(class_1856.method_8107((JsonObject)json)), material);
        }

        public void write(JsonObject parent, FabricMaterialIngredient ingredient) {
            if (!parent.isJsonObject()) {
                throw new JsonIOException("Cannot serialize an array of material ingredients, use CompoundIngredient instead");
            }
            parent.addProperty("type", ID.toString());
            if (ingredient.ingredient.material != WILDCARD) {
                parent.addProperty("material", ingredient.ingredient.material.toString());
            }
        }

        public FabricMaterialIngredient read(class_2540 buffer) {
            MaterialVariantId material = Objects.requireNonNull(MaterialVariantId.tryParse(buffer.method_19772()));
            return new FabricMaterialIngredient(Stream.generate(() -> new class_1856.class_1857(buffer.method_10819())).limit(buffer.method_10816()), material);
        }

        public void write(class_2540 buffer, FabricMaterialIngredient ingredient) {
            buffer.method_10812(ID);
            buffer.method_10814(ingredient.toVanilla().material.toString());
            class_1799[] items = ingredient.toVanilla().getPlainMatchingStacks();
            buffer.method_10804(items.length);
            for (class_1799 stack : items) {
                buffer.method_10793(stack);
            }
        }

        private Serializer() {
        }
    }

    public static class FabricMaterialIngredient
    implements CustomIngredient {
        private final MaterialIngredient ingredient;

        public FabricMaterialIngredient(Stream<? extends class_1856.class_1859> itemLists, MaterialVariantId material) {
            this.ingredient = new MaterialIngredient(itemLists, material);
        }

        public FabricMaterialIngredient(MaterialIngredient ingredient) {
            this.ingredient = ingredient;
        }

        public boolean test(class_1799 stack) {
            return this.ingredient.method_8093(stack);
        }

        public List<class_1799> getMatchingStacks() {
            return List.of(this.ingredient.method_8105());
        }

        public boolean requiresTesting() {
            return true;
        }

        public CustomIngredientSerializer<FabricMaterialIngredient> getSerializer() {
            return Serializer.INSTANCE;
        }

        public MaterialIngredient toVanilla() {
            return this.ingredient;
        }
    }
}

